// ================================
// Toolix Anti-Spoil – Background
// ================================

const DEFAULT_PROFILES = [
    {
        id: "main",
        name: "Profil principal",
        enabled: true,
        aliases: [],
        keywords: {
            fort: ["meurt", "mort", "décès", "fin", "épisode final", "dernier épisode"],
            moyen: ["twist", "révélation", "trahison", "boss", "vainqueur", "perd", "gagne"],
            faible: ["combat", "affronte", "retour", "départ"]
        }
    },

    {
        id: "pack-upcoming",
        name: "Sorties à venir",
        enabled: true,
        isPack: true,
        packId: "upcoming",
        aliases: [
            "prochaine saison",
            "épisode",
            "épisodes",
            "avant la sortie",
            "date de sortie",
            "à venir"
        ],
        keywords: {
            fort: [
                "leak",
                "spoiler avant sortie",
                "fin déjà connue",
                "révélé avant"
            ],
            moyen: [
                "rumeur",
                "théorie",
                "insider",
                "ce qui va se passer"
            ],
            faible: [
                "teaser",
                "trailer",
                "preview"
            ]
        }
    }
];

// =======================================
// INSTALL / UPDATE
// =======================================

chrome.runtime.onInstalled.addListener(() => {
    chrome.storage.sync.get(null, (data) => {
        const hasProfiles = Array.isArray(data.profiles) && data.profiles.length > 0;

        const defaults = {
            // Global flags
            enabled: data.enabled ?? true,
            pauseUntil: data.pauseUntil ?? null,
            hideComments: data.hideComments ?? true,
            maskTitlesOnly: data.maskTitlesOnly ?? false,

            // Domain rules
            whitelist: Array.isArray(data.whitelist) ? data.whitelist : [],
            blacklist: Array.isArray(data.blacklist) ? data.blacklist : [],

            // Profiles & packs
            profiles: hasProfiles ? data.profiles : DEFAULT_PROFILES,

            // Heuristics
            proximityLimit: data.proximityLimit ?? 12,

            // Stats (local only – RGPD safe)
            stats: {
                installedAt: data.stats?.installedAt ?? Date.now(),
                masks: data.stats?.masks ?? 0,
                packsAdded: data.stats?.packsAdded ?? {},
                presetsUsed: data.stats?.presetsUsed ?? {}
            }
        };

        chrome.storage.sync.set(defaults, () => {
            console.log("[Toolix Anti-Spoil] Initialisation terminée");
        });
    });
});

// =======================================
// MESSAGE HANDLING (future-proof)
// =======================================

chrome.runtime.onMessage.addListener((msg, sender, sendResponse) => {
    if (!msg || !msg.type) return;

    switch (msg.type) {
        case "ADD_PACK_USED":
            chrome.storage.sync.get(["stats"], (d) => {
                const stats = d.stats || {};
                stats.packsAdded = stats.packsAdded || {};
                stats.packsAdded[msg.packId] = (stats.packsAdded[msg.packId] || 0) + 1;
                chrome.storage.sync.set({ stats });
            });
            break;

        case "INCREMENT_MASK":
            chrome.storage.sync.get(["stats"], (d) => {
                const stats = d.stats || {};
                stats.masks = (stats.masks || 0) + 1;
                chrome.storage.sync.set({ stats });
            });
            break;

        case "PAUSE_UNTIL":
            chrome.storage.sync.set({ pauseUntil: msg.until });
            break;

        default:
            break;
    }
});
