const enabled = document.getElementById("enabled");
const pause = document.getElementById("pause");
const hideComments = document.getElementById("hideComments");
const options = document.getElementById("options");
const titlesOnly = document.getElementById("titlesOnly");
const presetSafe = document.getElementById("presetSafe");
const presetNormal = document.getElementById("presetNormal");
const presetLarge = document.getElementById("presetLarge");

function trackPreset(name, value) {
    chrome.storage.sync.get(["stats"], d => {
        const stats = d.stats || {};
        stats.presetsUsed = stats.presetsUsed || {};
        stats.presetsUsed[name] = (stats.presetsUsed[name] || 0) + 1;
        chrome.storage.sync.set({
            stats,
            proximityLimit: value
        });
    });
}

presetSafe.onclick = () => trackPreset("safe", 8);
presetNormal.onclick = () => trackPreset("normal", 12);
presetLarge.onclick = () => trackPreset("large", 18);

chrome.storage.sync.get(["maskTitlesOnly"], s => {
    titlesOnly.checked = !!s.maskTitlesOnly;
});

titlesOnly.onchange = () => {
    chrome.storage.sync.set({ maskTitlesOnly: titlesOnly.checked });
};

chrome.storage.sync.get(["enabled", "hideComments"], (s) => {
    enabled.checked = s.enabled !== false;
    hideComments.checked = s.hideComments !== false;
});

enabled.addEventListener("change", () => {
    chrome.storage.sync.set({ enabled: enabled.checked });
});

hideComments.addEventListener("change", () => {
    chrome.storage.sync.set({ hideComments: hideComments.checked });
});

pause.addEventListener("click", () => {
    chrome.storage.sync.set({ pauseUntil: Date.now() + 3600_000 }, () => window.close());
});

options.addEventListener("click", () => {
    chrome.runtime.openOptionsPage();
});


presetSafe.onclick = () =>
    chrome.storage.sync.set({ proximityLimit: 8 });

presetNormal.onclick = () =>
    chrome.storage.sync.set({ proximityLimit: 12 });

presetLarge.onclick = () =>
    chrome.storage.sync.set({ proximityLimit: 18 });

